%  The quarterly transition matrix T from sheet 'Table 1' in the
%  spreadsheet needs to be in memory before running this program

clc
clear Results

DaysPerQuarter=5*365/(4*7);  %  Adjust for 5-day workweek
for i=1:50
    w=i/(10*DaysPerQuarter)
    Td=(1-w)*eye(5)+w*T;
    Ch=Td^(365/4);
    Results(i,:)=[w,norm(Ch-T,1)];
end

% Pick the value of w from Results that minimizes the norm and put it in
% the blue cell in the spreadsheet, sheet 'Table 1'